---
name: flutter-ux-hardening
description: A guided Claude Code Agent Skill to plan, implement, test, review, and iteratively harden Flutter app UI/UX with robust edge-case handling, accessibility, performance, and agent-driven review cycles.
---

# Skill purpose

This Skill guides a developer through a repeatable workflow to elevate a Flutter app's UI/UX and resilience. It combines conversational planning, focused code and test generation, explicit edge-case/error handling, automated/agent review prompts, and iterative refactoring cycles until acceptance criteria are met.

The Skill is aimed at intermediate-to-advanced Flutter developers who want a structured, interactive process to: improve visuals and interaction flows, enforce accessibility and performance best practices, and ensure exhaustive handling of extreme user inputs and interactions.

# Step-by-step instructions Claude must follow

1. Gather context
  - Ask the developer for: project type (mobile/web/desktop), target platforms (iOS/Android/Web), Flutter version, existing architecture (e.g., MVVM, BLoC, Provider, Riverpod), current UX goals, and any known problem areas.
  - Ask for sample screens/flows or paste of relevant Dart/UI code and tests.
  - Ask for acceptance criteria (metrics like frame rendering target, accessibility requirements, max memory/CPU budgets, and what 