---
name: system-debug-logger
description: Creates a reusable Skill to instrument applications to automatically capture errors and exceptions into debug logs, with configurable output to server log files (e.g., /var/log/app.log) and/or console. Common triggers: "add error logging", "instrument exceptions for debug logs", "create logging configuration for production/dev".
---

# System Debug Logger Skill

Purpose

This Skill instruments an application or system to automatically capture runtime errors and exceptions into detailed debug logs so developers can rapidly diagnose root causes. It supports writing to a server log file (example: /var/log/app.log), console output for development, and produces rich debugging context (timestamps, severity, exception type, stack trace, request/context metadata, and optional correlation IDs).

Step-by-step instructions (what Claude must do when invoked)

1. Clarify environment and language/framework: explicitly ask which language, runtime, and environment (development or production) if not specified (examples: Python/Flask, Node/Express, Java/Spring Boot, Go, etc.).
2. Choose default logging strategy based on environment: console-only for development, file-based (plus optionally console) for production. Use /var/log/app.log as the default production file path unless user specifies another.
3. Provide a logging configuration snippet tailored to the target language/framework. Include:
   - structured log format (timestamp, level, logger name, message, exception type, stack trace, correlation/request id)
   - minimum log levels and recommended levels for exceptions (ERROR), warnings (WARN), and debug (DEBUG) when needed
   - example of capturing uncaught exceptions and logging stack traces
   - file handler configuration pointing to /var/log/app.log with rotation advice
   - console handler configuration for development
4. Include code examples for registering global/unhandled exception handlers (e.g., process.on('uncaughtException') and process.on('unhandledRejection') in Node; sys.excepthook or Flask error handlers in Python; Thread.setDefaultUncaughtExceptionHandler in Java).
5. Provide commands or instructions to ensure proper file permissions and directories (e.g., ensure /var/log exists, appropriate owner/group, and service user write permissions). Recommend use of log rotation (logrotate configuration) for production.
6. Highlight sensitive-data handling: instruct removal or redaction of PII/credentials from logs and recommend configuration options to filter sensitive fields.
7. Offer a minimal test plan and example steps to validate logging (simulate an error, check console and /var/log/app.log, verify stack trace and metadata present).
8. Provide optional advanced recommendations: structured JSON logs, correlation IDs via middleware, integration points for centralized log collectors (syslog, Fluentd, Logstash, CloudWatch), and monitoring/alerting triggers for ERROR-level logs.

Usage examples

- Example request: "Instrument my Node/Express app to log unhandled exceptions to /var/log/app.log and console in development. Show middleware and logrotate config." Response should include: a package suggestion (winston or pino), code snippet to initialize logger with file and console transports, global exception handlers, example middleware to attach correlation IDs, sample logrotate config file, and test steps.

- Example request: "Add exception logging to my Python Flask app for production — write to /var/log/app.log with stack traces and JSON format." Response should include: Python logging dictConfig or logging configuration, Flask errorhandler example capturing exceptions, sample JSON formatter, file handler with rotation (RotatingFileHandler or TimedRotatingFileHandler), permission notes, and validation steps.

- Example request: "How do I avoid logging passwords?" Response should include: patterns for redacting sensitive fields, central filtering middleware, example code to mask fields before logging, and mention of configuration toggles to enable/disable sensitive logging.

Best practices

- Always include stack traces and exception type for ERROR logs.
- Use structured logs (JSON) for easier parsing and integration with log aggregation tools.
- Do not log secrets or PII; implement redaction filters and review logs regularly.
- Use log rotation (logrotate or built-in rotating handlers) to prevent disk exhaustion.
- Write logs to a dedicated file (e.g., /var/log/app.log) with correct ownership and limited retention.
- Include correlation/request IDs so logs across services can be correlated.
- Use appropriate log levels and avoid excessive DEBUG logging in production.
- Provide a simple test harness to simulate exceptions during deployment verification.

When to ask follow-ups

- If language/framework, runtime version, or deployment environment are not specified, ask the user before generating code.
- If the user requires integration with a central logging system (ELK/Fluentd/CloudWatch), ask which system and credentials/endpoint preferences.

Placeholders and defaults

- Default production log path: /var/log/app.log
- Default development output: console
- Default rotation: daily rotation or size-based rotation (e.g., 50MB), configurable per user request
- Default sensitive-field list to redact: ["password", "token", "authorization", "ssn", "credit_card"] (user can customize)

Related notes

- Ensure the user has permission to write to /var/log; provide chown/chmod commands when appropriate.
- Recommend using a process manager (systemd, supervisor) so logs persist and the service restarts on failure.

