---
name: coverage-improvement-planner
description: Analyze test coverage, generate a coverage report (coverage.md) that highlights missing/insufficient areas, create a prioritized remediation plan (plan.mode) and an actionable todo list (todo.md), group tasks for safe parallel agent execution, assign tasks to agents, and produce a final result report (result.md) showing before/after coverage and impact.
---

Skill purpose

This Skill automates analysis of code-test coverage, produces a human-readable report of coverage gaps, generates a prioritized remediation plan and an actionable todo list, groups tasks so multiple agents can run in parallel without conflicts, assigns groups to agents, and compiles a final result report showing coverage improvements and impact.

Step-by-step instructions Claude must follow

1. Gather inputs
   - Detect or request the repository root and the coverage data format (e.g., coverage.py XML/HTML, lcov, jacoco). If no coverage data exists, instruct or run the configured test/coverage command to produce it (provide defaults below).
   - Get configuration: list of modules/components, risk weights or mapping (service-critical modules), agent count (number of parallel workers), and any dependency map if available.

2. Normalize coverage data
   - Parse coverage artifacts (coverage.xml, lcov.info, jacoco.xml, etc.) and extract per-file and per-module coverage percentages, missing lines/branches, and tests mapped to files when available.
   - If only raw tests exist, run test suite with coverage enabled using a reasonable default command (see Best Practices).

3. Score and prioritize gaps
   - For each module/file, compute a priority score combining: coverage shortfall (target_percent - current_percent), module risk weight (service-critical higher), recent churn (git diff/commit frequency if available), and dependency centrality (core libraries higher).
   - Sort missing areas by descending priority.

4. Produce coverage.md (report of insufficiencies)
   - Create coverage.md containing:
     - Summary: overall coverage percentage and number of modules/files below target.
     - Table/list: per-module coverage, target, shortfall, risk score, key missing files and representative missing lines or branches.
     - Examples of failing / untested behaviors where detectable (stack traces, uncovered functions).
     - Recommended target coverage per module (defaults: 80% overall, 90% critical modules).

5. Create plan.mode (structured remediation plan)
   - For the top-priority items, create a plan with steps that are actionable and time-estimable. Each plan entry should include:
     - id, module, description of missing tests to add, estimated effort (S/M/L), priority score, dependencies, expected coverage gain estimate.
   - Ensure plan emphasizes high-risk modules first.

6. Generate todo.md (actionable todo list)
   - Convert plan.mode into a flat todo.md list of tasks with checkboxes and metadata: assigned_agent (placeholder), estimated_hours, blocking_dependencies, group_id.
   - Include grouping information for parallel execution: generate groups such that tasks inside different groups have no code dependencies between them. Use module dependency graph or file path heuristics to create independent groups.

7. Assign tasks to agents
   - Given an agent_count, distribute groups among agents approximately evenly by total estimated effort while preserving group integrity.
   - Annotate todo.md with assigned_agent names or placeholders (agent-1, agent-2, …).

8. Provide concurrency safety guidance
   - For each group, list files to touch and recommended isolation strategies (create feature branches, use test doubles/mocks, lock critical shared resources if necessary).
   - Add commands to run unit tests for only the affected modules to speed iteration (examples included in Best Practices).

9. Execute (optional automated enactment)
   - Optionally orchestrate agents to run tasks in parallel if provided tools are available. If not executing, produce instructions and commands each agent should run.

10. Recalculate coverage and produce result.md
   - After tasks complete (or simulated), re-run coverage and compute new per-module and overall coverage.
   - Produce result.md containing:
     - Summary before and after (overall and per-module)
     - Visual delta (percent point change) and list of modules improved and any remaining gaps
     - Metrics: tests added, lines covered, branches covered, estimated risk reduction
     - Recommended follow-ups or remaining blockers

Usage examples

Example 1 — Typical flow (developer-run)
- Inputs: repository root, coverage.xml (coverage.py), agent_count=3
- Claude commands:
  1. Parse coverage.xml and git history
  2. Create coverage.md listing top 15 deficient modules
  3. Produce plan.mode with 10 remediation entries prioritized by risk
  4. Emit todo.md grouped into 3 groups and assign group->agent mapping
  5. Output result.md template to fill after execution

Example 2 — Fully automated with test run
- If no coverage artifact exists, use default commands to create it, for example:
  - Python projects (coverage.py): python -m coverage run -m pytest && python -m coverage xml -o coverage.xml
  - Node.js projects (nyc): npx nyc --reporter=lcov --reporter=json-summary npm test
  - Java (maven/jacoco): mvn test jacoco:report
- Then follow steps 2–10 above.

Best practices

- Default targets: set overall target to 80% and critical modules to 90% unless the team specifies otherwise.
- Risk mapping: allow a config file (e.g., coverage_config.yaml) to provide module risk weights; fallback to heuristics: modules under src/api, src/core, or with many imports get higher risk.
- Dependency graph: use import analysis (static) or simple path-based grouping to avoid overlapping file edits across groups.
- Atomic changes: recommend each task be implemented on its own branch and produce minimal commits to reduce merge conflicts.
- Test-only runs: provide commands to run tests for specific modules to reduce CI time (examples per language included above).
- Estimation guidance: Small (<=2h), Medium (2–8h), Large (>8h).

Templates and filenames created

- coverage.md — human-readable deficiencies and suggested targets
- plan.mode — structured remediation plan (YAML/JSON-like entries)
- todo.md — markdown checklist with group and agent assignments
- result.md — final before/after coverage report

Placeholders and configuration

- If coverage format or repository layout is unknown, the Skill should prompt for:
  - coverage artifact path or test/coverage command
  - module risk mapping or accept default heuristics
  - agent_count
- Provide optional config file: coverage_config.yaml (example fields: targets, risk_weights, ignore_paths)

Best-effort heuristics used when data is missing

- If no dependency graph: group tasks by top-level directory and avoid assigning two tasks that touch the same directory to different agents.
- If no churn data: assume neutral churn and rely on risk weights only.

When to run this Skill

- After feature branches are merged or before a release to prioritize remediation
- As a periodic (weekly/monthly) health check

Related commands and scripts (examples)

- Python coverage default:
  - python -m coverage run -m pytest
  - python -m coverage xml -o coverage.xml
- Node.js nyc default:
  - npx nyc --reporter=lcov --reporter=json-summary npm test
- Java (maven + jacoco):
  - mvn clean test jacoco:report

Examples of plan.mode entry (conceptual)
- id: P-001
  module: src/api/user
  description: Add unit tests for input validation and error paths in user creation
  estimate: Medium
  priority_score: 9.5
  dependencies: []
  expected_coverage_gain: 7

Outputs

- The Skill must write three primary files at repository root: coverage.md, plan.mode, todo.md. After remediation or a simulated run, write result.md.

Best practices for parallel agent execution

- Ensure tasks within a group do not edit the same files.
- Prefer read-only or additive changes (new test files) to reduce merge conflicts.
- Use feature branches per task and merge via continuous integration after tests pass.

Notes

- This Skill focuses on planning and coordination; actual test implementation can be assigned to agents but is out of scope for full automation unless the environment supports code edits and CI runs.
- Provide clear, minimal shell commands and config snippets in generated reports so developers can act without extra clarification.

supporting_files: []
