---
name: fix-async-await
description: Fixes JavaScript or TypeScript code that misses required keywords for async/await usage. Use when reviewing or correcting code with asynchronous functions, promises, or errors related to async/await syntax.
---

# Fix Async/Await Issues

## Instructions

When the user provides code with async/await problems, or asks to fix missing keywords in asynchronous JavaScript or TypeScript code:

1. **Identify issues**: Look for places where await is used without the enclosing function being declared as async, or where async functions are missing proper handling.

2. **Explain the problem**: Describe why the keyword is necessary, such as how await can only be used inside async functions.

3. **Suggest corrections**: Provide guidance on adding the async keyword to the function declaration, and ensure top-level awaits are handled appropriately if applicable.

4. **Handle common cases**: Check for arrow functions, regular functions, and methods in classes or objects.

5. **Best practices**: Remind to handle errors with try/catch around awaits, and consider promise chaining alternatives if needed.

Keep explanations clear and step-by-step, focusing on teaching the user about proper async/await usage without including actual code snippets.