---
name: code-commenter
description: Adds easy-to-understand comments to program source code. Use when explaining code, adding documentation to scripts, or when the user asks to "add comments" or "explain this code with comments."
---

# Code Commenter

## Instructions

When adding comments to source code, follow these steps:

1. **Understand the code**: Read and comprehend the overall structure, functions, variables, and logic flow.
2. **Identify key sections**: Break the code into logical parts such as imports, variables, functions, loops, conditionals, and main execution.
3. **Add descriptive comments**: For each section, write clear, concise comments that explain what the code does, why it is written that way, and any important details. Use simple language suitable for beginners.
4. **Use appropriate comment styles**: Match the comment syntax to the programming language (e.g., // for single-line in JavaScript, # for Python).
5. **Keep it non-intrusive**: Place comments above or beside the code without altering the functionality. Ensure comments are helpful but not overly verbose.
6. **Highlight potential issues**: Note any common pitfalls or areas that might need attention.

## Best Practices

- Make comments educational and analogy-based where possible to aid understanding.
- Avoid adding code; only insert explanatory text as comments.
- Ensure the commented code remains executable and unchanged in behavior.