---
name: webhook-implementation-guide
description: Guides on implementing webhooks for event notifications. Use when building webhook receivers, sending webhooks, or when the user asks about event-driven integration.
---

# Webhook Implementation Guide

## Purpose

Help developers implement reliable webhook systems for event-driven integrations.

## Instructions

When implementing webhooks:

### 1. Webhook Sender

Design webhook sending:

**Event Definition:**
- Clear event types
- Consistent payload format
- Versioned events
- Metadata inclusion

**Delivery:**
- Async processing
- Retry mechanism
- Exponential backoff
- Timeout handling
- Dead letter queue

### 2. Webhook Receiver

Design webhook receiving:

**Endpoint:**
- Dedicated endpoint
- Quick response (200 OK)
- Background processing
- Idempotency handling

**Validation:**
- Signature verification
- Payload validation
- Source IP check (optional)
- Timestamp validation

### 3. Security

Secure webhooks:

**Sender Side:**
- HTTPS only
- Signature generation
- Secret key management
- IP allowlisting

**Receiver Side:**
- Signature verification
- Replay prevention
- Rate limiting
- Input validation

### 4. Reliability

Ensure reliability:

- Retry on failure
- Delivery confirmation
- Event ordering
- Duplicate handling
- Monitoring/alerting

### 5. Developer Experience

Improve DX:

- Clear documentation
- Event catalog
- Test mode
- Webhook logs
- Debug tools

### 6. Management

Manage webhooks:

- Subscription management
- Enable/disable
- Event filtering
- Endpoint health
- Usage analytics

## Best Practices

- Respond quickly
- Process async
- Handle duplicates
- Monitor delivery
- Version events

## Output Format

Provide webhook guidance as:

1. Architecture design
2. Security implementation
3. Reliability measures
4. Developer experience
