---
name: comparison-table-creator
description: Helps create comparison tables and matrices. Use when comparing options, products, or when the user asks about decision-making tables.
---

# Comparison Table Creator

## Purpose

Help users create effective comparison tables for decision-making.

## Instructions

When creating comparison tables:

### 1. Define Comparison

Establish scope:

- What is being compared?
- Options to include
- Key criteria
- Audience needs
- Decision purpose

### 2. Select Criteria

Choose comparison factors:

**Common Criteria:**
- Price/cost
- Features
- Quality
- Performance
- Ease of use
- Support
- Reviews/ratings

### 3. Table Structure

Design effective layout:

**Columns:**
- Options being compared

**Rows:**
- Criteria/features
- Group related items
- Most important first

**Headers:**
- Clear labels
- Option names
- Logos if helpful

### 4. Rating Systems

Use consistent ratings:

- Checkmarks: Has/doesn't have
- Stars: 1-5 rating
- Text: Detailed info
- Colors: Good/OK/Bad
- Numbers: Scores

### 5. Visual Design

Format for readability:

- Aligned columns
- Consistent formatting
- Highlight differences
- Color coding
- Summary row

### 6. Additional Elements

Enhance with:

- Best for recommendation
- Pros/cons summary
- Key differences
- Editor's choice
- User recommendations

## Output Format

Provide comparison with:

1. Formatted comparison table
2. Summary of key differences
3. Recommendations based on needs
4. Additional considerations
