---
name: api-idempotency-patterns
description: Guides on implementing idempotent API operations. Use when preventing duplicate requests, building reliable APIs, or when the user asks about idempotency keys.
---

# API Idempotency Patterns

## Purpose

Help developers implement idempotent APIs for reliable request handling.

## Instructions

When implementing idempotency:

### 1. Idempotency Basics

Understand idempotency:

- Same request = same result
- Safe to retry
- No duplicate side effects
- Critical for payments, orders

### 2. Idempotency Keys

Implement idempotency keys:

**Key Generation:**
- Client-generated UUID
- Hash of request content
- Business identifier

**Key Storage:**
- Key-value store
- Database table
- TTL-based expiration

### 3. Processing Flow

Handle idempotent requests:

1. Receive request with key
2. Check if key exists
3. If exists: return stored response
4. If new: process and store
5. Return response

### 4. Storage Design

Design storage:

**Store:**
- Idempotency key
- Request fingerprint
- Response data
- Status (processing/complete)
- Timestamp

**Expiration:**
- TTL for key expiration
- Cleanup processed keys
- Balance storage costs

### 5. Race Conditions

Handle concurrent requests:

- Locking mechanisms
- Optimistic concurrency
- Processing state tracking
- Retry with backoff

### 6. Error Handling

Handle error scenarios:

- Process failed: allow retry
- Network timeout: check status
- Partial failures
- Clear error responses

## Best Practices

- Require for mutations
- Clear documentation
- Reasonable TTL
- Test concurrent requests
- Monitor duplicate rates

## Output Format

Provide idempotency guidance as:

1. Key design
2. Storage approach
3. Processing flow
4. Error handling
